///////////////////////////////////////////////
//
//  Dec-2021 E. Nacher --> RunAction.cc
//
//  Defines the histograms and the function
//  to fill them. Opens and saves the root file...
//
///////////////////////////////////////////////

#include "RunAction.hh"
#include "G4Run.hh"
#include "G4ios.hh"
#include "fstream"
#include "iomanip"

using namespace std;

RunAction::RunAction()
{ }

RunAction::~RunAction()
{ }

void RunAction::BeginOfRunAction(const G4Run*)
{
    outputFile  = new TFile("./data/output.root", "recreate");
    
    h_1 = new TH1F("h_1", "Crystal energy", 4096, 0., 10000.);
    h_2 = new TH1F("h_2", "Plastic energy", 4096, 0., 10000.);
    h_3 = new TH1F("h_3", "Crystal energy beta gated", 4096, 0., 10000.);
}

void RunAction::EndOfRunAction(const G4Run*)
{
    h_1 -> Write();
    delete h_1;
    h_2 -> Write();
    delete h_2;
    h_3 -> Write();
    delete h_3;
    
    outputFile->Close();
    delete outputFile;
    
    cout << endl << endl << "SIMULATION FINISHED!" << "\033[m" << endl << endl;
}

void RunAction::fillHistograms(G4double ener, G4double ener2)
{
    h_1 -> Fill(ener);
    h_2 -> Fill(ener2);
    
    if(ener2 > 5.) h_3->Fill(ener);
}


