///////////////////////////////////////////////
//
//  Dec-2021 E. Nacher --> EventAction.cc
//
//  Fills 2 histograms at the end of each event
//  using the fillHistograms() function defined
//  in RunAction.cc
//
///////////////////////////////////////////////

#include "EventAction.hh"
#include "RunAction.hh"

#include "G4Event.hh"
#include "G4EventManager.hh"
#include "G4UnitsTable.hh"

#include "globals.hh"
#include "G4ios.hh"
#include "fstream"
#include "iomanip"

using namespace std;
using namespace CLHEP;

EventAction::EventAction(RunAction* RunAct)
:runAction(RunAct)
{}

EventAction::~EventAction()
{}

void EventAction::BeginOfEventAction(const G4Event*)
{
    energy = 0.;
    energy2 = 0.;
}

void EventAction::EndOfEventAction(const G4Event* evt)
{
    G4int event = evt -> GetEventID();
    if(event % 5000 == 0) {
        
        cout << endl << endl << endl << "\033[1;31m";
        cout << event << " events simulated" << endl;
        system("/bin/date");
        
        for(int i=0; i<5; i++) cout << "\x1b[A";
        
    }
    
    // fill histograms
    
        runAction-> fillHistograms(energy, energy2);
}



