// PRACTICA ROOT - MASTER TEAFN 2021/22 - S.E.A. ORRIGO
//
// Creation of TGraphs and TGraphErrors
//

/* Ejercicios:

(1) Crear nuevos TGraph y TGraphErrors utilizando los datos de basic.dat

(2) Guardar los graphs creados en un fichero .root

*/

//C,C++ Libraries
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <cmath>
#include <cstdlib>
#include <vector>
#include <iomanip>

// ROOT libraries
#include <TROOT.h>
#include <TF1.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TCanvas.h>
#include <TTree.h>
#include <TChain.h>
#include <TObject.h>
#include <TStyle.h>
#include <TBrowser.h>
#include <TApplication.h>
#include <TFile.h>
#include <TRandom3.h>
#include <TCutG.h>
#include <TString.h>
#include <TObjArray.h>
#include <TPaveLabel.h>
#include <TGraphErrors.h>

void graph() {

   Double_t x, y, z;

   TGraph *graph = new TGraph();
   TGraphErrors *grapherr = new TGraphErrors();

   // Read data from a file and fill the histograms
   std::ifstream inputfile("basic.dat", std::ios::in );
   for (Int_t i=0; i<10; i++) {
      inputfile >> x >> y >> z;
      graph->SetPoint(i,x,2*x);
      grapherr->SetPoint(i,x,2*x);
      grapherr->SetPointError(i,0.1,0.1);
   }
   inputfile.close();

   std::cout<<"Number of points = "<< graph->GetN() <<std::endl;

   TCanvas *c1 = new TCanvas("c1","The Graph example",200,10,700,900);
   c1->Divide(1,2);
   c1->cd(1);

   graph->SetMarkerStyle(4);
   graph->SetMarkerColor(kRed);
//   graph->GetXaxis()->SetLimits(-1,1);
//   graph->GetHistogram()->SetMinimum(0);
//   graph->GetHistogram()->SetMaximum(2); 
   graph->GetXaxis()->SetTitle("X-axis");
   graph->GetYaxis()->SetTitle("Y-axis");
   graph->SetTitle("No errors");
   graph->Draw("APL");

   c1->cd(2);

   grapherr->SetMarkerStyle(4);
   grapherr->SetMarkerColor(kBlue);
   grapherr->GetXaxis()->SetTitle("X-axis");
   grapherr->GetYaxis()->SetTitle("Y-axis");
   grapherr->SetTitle("Same with errors");
   grapherr->Draw("AP");

   return;
}
