////////////////////////////////////////////////////////////////
//
//     Dec-2021 E. Nacher --> SteppinAction.cc
//
//     Collects the energy deposited in sensitive volumes
//
////////////////////////////////////////////////////////////////

#include "SteppingAction.hh"
#include "EventAction.hh"
#include "G4SteppingManager.hh"
#include "G4ios.hh"

using namespace std;
using namespace CLHEP;

SteppingAction::SteppingAction(EventAction* EvAct)
:eventAction(EvAct)
{ }

SteppingAction::~SteppingAction()
{ }

void SteppingAction::UserSteppingAction(const G4Step* aStep)
{
    // collect the energy deposited in the sensitive volume
    
    const G4String currentPhysicalName
    = aStep->GetPreStepPoint()->GetPhysicalVolume()->GetName();
    
//    const G4int currentCopyNumber
//    = aStep->GetPreStepPoint()->GetTouchableHandle()->GetCopyNumber();
    
    G4String name=
    aStep->GetTrack()->GetDefinition()->GetParticleName();
    
    G4double EdepStep = aStep->GetTotalEnergyDeposit() / keV;
    
    
    if(currentPhysicalName == "physNaI"){
        eventAction->energy = eventAction->energy + EdepStep;
    }
    if(currentPhysicalName == "physPlas"){
        eventAction->energy2 = eventAction->energy2 + EdepStep;
    }

/*    
    if(currentPhysicalName == "Crystal"||currentPhysicalName == "Crystal2"){
        eventAction->energy = eventAction->energy + EdepStep;
    }
*/
}


