// PRACTICA ROOT - MASTER TEAFN 2021/22 - S.E.A. ORRIGO
//
// Adapted from the ROOT tutorial (as modified by A. Tolosa):
// // $ROOTSYS/tutorials/tree/basic.C
// // $ROOTSYS/tutorials/tree/tree1.C
// 
// Shows how to read & write an ASCII file and fill a TTree & Branch
// 

#include <iostream>
#include <fstream>

#include "TFile.h"
#include "TTree.h"

#include "TCanvas.h"
#include "TH1D.h"
#include "TH2D.h"

// Utilizamos el mismo fichero basic.dat
// que tiene tres columnas de números decimales (datos)
// Definimos una clase para leer estos datos
class myEvent_t
{
public:
  myEvent_t():x(0),y(0){}
  ~myEvent_t(){}
   Double_t x;
   Double_t y;
   //Double_t z;
};

// Función para escribir un tree
int tree_writer() 
{
  // fichero input (ifstream)
  std::ifstream ifile("basic.dat");
  
  // fichero output de ROOT
  TFile * otfile = TFile::Open("basic.root","RECREATE");
  
  // todo tree de ROOT tiene que ir ligado a un fichero!!
  // Argumentos del constructor
  //-- Nombre del TTree (como cualquer objeto de ROOT)
  //-- Título del TTree (se puede omitir, "")
  TTree * myTree = new TTree("ElTree","data from ascii file");
  
  // declaramos un objeto de la clase myEvent_t
  myEvent_t anEvent;
  
  // La función TTree::Branch() se usa para definir cada rama. Argumentos:
  // --nombre de la rama, eg "myBranch"
  // --dirección de memoria de un objeto. Cada que vez que se haga tree->Fill(), 
  // generará una nueva entrada en el tree, con valores los que tenga este objeto
  // --listado del nombre de las hojas y el tipo, con sintaxis "nombre/tipo:nombre/tipo:etc."
  myTree->Branch("myBranch.",&anEvent,"x/D:y/D");

  // leemos el ASCII
  while ( ifile.good() ) 
  {
    Double_t dummyColumn; //dummy es una columna que no se usa
    // metemos los valores de las tres columnas en x,y,z
    ifile >> anEvent.x >> anEvent.y >> dummyColumn;
   
    // comprobamos si hemos llegado a final de fichero
    if ( ifile.eof() ) break;
      
    // crear una nueva entry del tree
    myTree->Fill();
  }

   // imprimimos en pantalla el numero de entries del tree
   std::cout << "Number of entries: " << myTree->GetEntries() << std::endl;
   
   // cerramos el fichero ASCII
   ifile.close();

   // escribimos el TTree y cerramos el fichero basic.root
   otfile->Write();
   otfile->Close();
   
   return 0;
}

