// PRACTICA ROOT - MASTER TEAFN 2021/22 - S.E.A. ORRIGO
//
// Adapted from the ROOT tutorial (as modified by A. Tolosa):
// // $ROOTSYS/tutorials/tree/basic.C
// // $ROOTSYS/tutorials/tree/tree1.C
// 
// Shows how to read the TTree created with tree_writer.C
// 

#include <iostream>
#include <fstream>

#include "TFile.h"
#include "TTree.h"

#include "TCanvas.h"
#include "TH1D.h"
#include "TH2D.h"

/* Ejercicio:

Abrir en ROOT el Tree del fichero basic.root y crear el grafico bidimensional de y en función de y con las siguientes condiciones:
1) x>0
2) x<0
Guardarlos como imagenes.

*/

// Utilizamos el mismo fichero basic.dat
// que tiene tres columnas de números decimales (datos)
// Definimos una clase para leer estos datos
class myEvent_t
{
public:
  myEvent_t():x(0),y(0){}
  ~myEvent_t(){}
   Double_t x;
   Double_t y;
   //Double_t z;
};


// Función para leer el tree creado con tree_writer()
int tree_reader()
{
  // abrimos el fichero en modo lectura
  TFile * ifile = TFile::Open("basic.root","read");
  // si el fichero no existe, TFile::Open devolerá un puntero nulo, cero
  if( ifile == NULL ) return -1;  
  // creamos un tree vacio
  TTree * itree = 0;
  // buscamos dónde está el tree que nos interesa, llamado "ElTree"
  ifile->GetObject("ElTree", itree);
  // si no lo ha encontrado, itree será nulo, cero
  if( itree == NULL) return -2;
  
  // creamos una objeto de clase myEvent_t
  myEvent_t anEvent;
  
  // direccion de memoria de la rama a obtener
  itree->SetBranchAddress("myBranch.", &(anEvent.x));
  
  // obtenemos e imprimimos por pantalla el numero de entries del tree
  Long64_t nEntries = itree->GetEntries();
  std::cout << " Tree with " << nEntries << " entries" << endl;
  
  // leemos el tree a traves de un bucle
  for( Long64_t i = 0; i<nEntries; ++i)
  {
    // obtenemos la i-esima entrada  
    itree->GetEntry(i);
    // sacamos por pantalla los valores de esta entrada
    std::cout << anEvent.x << "\t" <<
	         anEvent.y << std::endl;    
  }  
  
  // cerramos el fichero basic.root
  ifile->Close();

  // salimos de la macro  
  return 0;
}

