// PRACTICA ROOT - MASTER TEAFN 2020 - S.E.A. ORRIGO
//
// Shows how to define parametric functions
//

/* Ejercicios:

(1) Cambiar los parametros de la segunda function y ver el resultado

(2) Definir y plotar una funcion parabolica

*/

//C,C++ Libraries
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <cmath>
#include <cstdlib>
#include <vector>
#include <iomanip>

// ROOT libraries
#include <TROOT.h>
#include <TF1.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TCanvas.h>
#include <TTree.h>
#include <TChain.h>
#include <TObject.h>
#include <TStyle.h>
#include <TBrowser.h>
#include <TApplication.h>
#include <TFile.h>
#include <TRandom3.h>
#include <TCutG.h>
#include <TString.h>
#include <TObjArray.h>
#include <TPaveLabel.h>

void functions() {

   TCanvas *c1 = new TCanvas("c1","The Function example",200,10,700,900);
   c1->Divide(1,2);
   c1->cd(1);

   //How to use a ROOT-defined function: gaussian
   TF1 * funct1 = new TF1("funct1","gaus(0)",0,10);
   funct1->SetParameters(10,4,1);
   funct1->SetLineColor(4);
   funct1->SetLineWidth(6);
   funct1->Draw();

   c1->cd(2);

   //How to define manually a function
   TF1 * funct2 = new TF1("funct2","[0]*exp(-0.5*((x-[1])/[2])**2)",0,10);
   funct2->SetParameters(10,4,1);
   funct2->SetLineColor(2);
   funct2->SetLineWidth(6);
   funct2->Draw();
   funct1->SetLineStyle(2);
   funct1->Draw("same");

   return;
}
