//
// Adapted from the ROOT tutorial 
// // $ROOTSYS/tutorials/tree/basic.C
// // $ROOTSYS/tutorials/tree/tree1.C
// 
// Shows how to read & write an ASCII file and fill a TTree & Branch
// 
// Compilación: 
// .L basic_writer.C++

#include <iostream>
#include <fstream>

#include "TFile.h"
#include "TTree.h"


// el fichero data.txt tiene dos columnas de datos
// definimos una clase para leer estos datos
class myEvent_t
{
public:
  myEvent_t(){}
  ~myEvent_t(){}
   Int_t detectorID;
   Float_t depositedE;
};

// Función para escribir un tree
int basic_writer() 
{
  // fichero input (ifstream)
  std::ifstream ifile("152Eu_data.txt");
  
  // fichero de salida de ROOT
  TFile * otfile = TFile::Open("152Eu_data.root","RECREATE");
  
  // todo tree de ROOT tiene que ir ligado a un fichero!!
  // Argumentos del constructor
  //-- Nombre del TTree (como cualquer objeto de ROOT)
  //-- Títutlo del TTree (se puede omitir, "")
  TTree * myTree = new TTree("iTED","energy data of an iTED detector");
  
  // declaramos un objeto de la clase myEvent_t
  myEvent_t anEvent;
  
  // La función TTree::Branch() se usa para definir cada rama. Argumentos:
  // --nombre de la rama, eg "myBranch"
  // --dirección de memoria de un objeto. Cada que vez que se haga tree->Fill(), 
  //       generará una nueva entrada en el tree, con valores los que tenga este objeto
  // --listado del nombre de las hojas y el tipo, con sintaxis "nombre/tipo:nombre/tipo:etc"
  myTree->Branch("SCATTERER",&anEvent, "detectorID/I:depositedE/F");

  // leemos el ASCII
  while ( ifile.good() ) 
    {
      // metemos los valores de las dos columnas en las variables detectorID y depositedE
      ifile >> anEvent.detectorID >> anEvent.depositedE;
      
      // comprobamos si hemos llegado a final de fichero
      if ( ifile.eof() ) break;
      
      // crear una nueva entry del tree si el detector posee el identificativo que queremos
      //--para seleccionar otro PSD cambiar al detectorID correspondiente (ver guion).
      if (anEvent.detectorID==0)
	myTree->Fill();
    }
  
  // imprimimos en pantalla el numero de entries del tree
  std::cout << "Number of entries: " << myTree->GetEntries() << std::endl;
  
  // cerramos el fichero ASCII
  ifile.close();
  
  // escribimos el TTree y cerramos el fichero
  otfile->Write();
  otfile->Close();
  
  return 0;
}

