//
// Adapted from the ROOT tutorial 
// // $ROOTSYS/tutorials/tree/basic.C
// // $ROOTSYS/tutorials/tree/tree1.C
// 
// Shows how to read & write an ASCII file and fill a TTree & Branch
// 
// Compilación: 
// .L basic_reader.C++

#include <iostream>
#include <fstream>

#include "TFile.h"
#include "TTree.h"

// el tree creado en el paso anterior posee datos de detectorID y depositedE
// definimos una clase para obtener estos datos
class myEvent_t
{
public:
  myEvent_t(){}
  ~myEvent_t(){}
   Int_t detectorID;
   Float_t depositedE;
};


// Función para leer el tree creado con basicWriter()
int basic_reader()
{
  // abrimos el fichero en modo lectura
  TFile * ifile = TFile::Open("152Eu_data.root","read");
  // si el fichero no existe, TFile::Open devolerá un puntero nulo, cero
  if( ifile == NULL ) return -1;

  // creamos un tree vacio
  TTree * itree = 0;
  // buscamos dónde está el tree que nos interesa, llamado "iTED"
  ifile->GetObject("iTED", itree);
  // si no lo ha encontrado, itree será nulo, cero
  if( itree == NULL) return -2;
  
  // creamos una objeto de clase myEvent_t
  myEvent_t anEvent;
  
  // direccion de memoria de la rama a obtener
  itree->SetBranchAddress("SCATTERER", &(anEvent.detectorID));
  
  // obtenemos e imprimimos por pantalla el numero de entries del tree
  Long64_t nEntries = itree->GetEntries();
  std::cout << " Tree with " << nEntries << " entries" << endl;
  
  // leemos el tree a traves de un bucle (solo el 20% de las entradas)
  for( Long64_t i = 0; i<nEntries*0.2; ++i)
  {
    // obtenemos la i-esima entrada
    itree->GetEntry(i);

    // sacamos por pantalla los valores de esta entrada
    std::cout << anEvent.detectorID << "\t" 
	      << anEvent.depositedE << std::endl;    
  }

  // cerramos el fichero de entrada
  ifile->Close();

  // salimos de la macro
  return 0;
}

