// PRACTICA ROOT - MASTER TEAFN 2018 - S.E.A. ORRIGO
//
// Adapted from the ROOT tutorial: $ROOTSYS/tutorials/hist/fillrandom.C
//
// Shows how to define a 1-D histogram, fill it with a random distribution based on a parametric function
// and save both to file
//

/* Ejercicios:

(1) Cambiar el bin del histograma en su misma definición y también col comando Rebin(), es: histo->Rebin(2);

(2) Repetir el trabajo:
    A) Crear una segunda TCanvas
    B) Crear una funcion distinta
    C) crear un segundo histograma "histo2" con mismo bin del primero

(3) Descomentar la sección "Sum of histograms"

(4) Guardar en el fichero también histo2 y hsum

*/

//C,C++ Libraries
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <cmath>
#include <cstdlib>
#include <vector>
#include <iomanip>

// ROOT libraries
#include <TROOT.h>
#include <TF1.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TCanvas.h>
#include <TTree.h>
#include <TChain.h>
#include <TObject.h>
#include <TStyle.h>
#include <TBrowser.h>
#include <TApplication.h>
#include <TFile.h>
#include <TRandom3.h>
#include <TCutG.h>
#include <TString.h>
#include <TObjArray.h>
#include <TPaveLabel.h>

string histograms() {

   TCanvas *c1 = new TCanvas("c1","The Histogram example",200,10,700,900);
   c1->Divide(1,2);
   c1->cd(1);

   // Here we define a more complex function
   TF1 * funct3 = new TF1("funct3","x*gaus(0) + [3]*abs(sin(x)/x)",0,10);
   funct3->SetParameters(10,4,1,20);
   funct3->SetLineColor(4);
   funct3->SetLineWidth(6);
   funct3->Draw();
   TPaveLabel * label1 = new TPaveLabel(5,39,9.8,46,"The function");
   label1->Draw();

   c1->cd(2);

   // Create a one dimensional histogram (one float per bin)
   // and fill it following the distribution in funct3
   TH1F * histo1 = new TH1F("histo1","Test random numbers",200,0,10);
   histo1->FillRandom("funct3",10000);
   histo1->SetXTitle("Channels");
   histo1->SetYTitle("Counts");
   histo1->SetFillColor(kCyan);
   histo1->SetLineColor(4);
   histo1->SetLineWidth(1);
   histo1->Draw();
   TPaveLabel * label2 = new TPaveLabel(5,129,9.8,159,"The histogram");
   label2->Draw();

/*
   // Sum of histograms
   TH1F * hsum = new TH1F("hsum","Sum of histo1 and histo2",200,0,10);
   hsum->Add(histo1,histo2,1,1);
   hsum->SetLineColor(2);
   hsum->SetLineWidth(2);
   hsum->Draw();
   histo1->Draw("same");
   histo2->Draw("same");
*/

   // Open a ROOT file and save the function and histogram
   TFile myfile("histograms.root","RECREATE");
   funct3->Write();
   histo1->Write();

   c1->SaveAs("histograms.png");

   return "Hecho! ;-)";
}
