// PRACTICA ROOT - MASTER TEAFN 2018 - S.E.A. ORRIGO
//
// Creation of TCanvas y 2-D histograms
// Fit of 1-D histograms
//

/* Ejercicios:

(1) Crear una TCanvas triple y dibujar hx, hz y hxy

(2) Crear el histograma hy y guardarlo en fichero

(3) Crear los histogramas 2D que faltan, dibujarlos y guardarlos

(4) Fitear hy con la funcion adecuada y leer los parametros del fit

*/

//C,C++ Libraries
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <cmath>
#include <cstdlib>
#include <vector>
#include <iomanip>

// ROOT libraries
#include <TROOT.h>
#include <TF1.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TCanvas.h>
#include <TTree.h>
#include <TChain.h>
#include <TObject.h>
#include <TStyle.h>
#include <TBrowser.h>
#include <TApplication.h>
#include <TFile.h>
#include <TRandom3.h>
#include <TCutG.h>
#include <TString.h>
#include <TObjArray.h>
#include <TPaveLabel.h>

// Note: 2 ways of defining histograms
TH1F hx("hx","x distribution",100,-4,4);
TH1F *hz = new TH1F("hz","z distribution",100,-1,20);

// Define a 2-D histogram
TH2F hxy("hxy","y vs x",40,-4,4,40,-4,4);

void histo_fit() {

   gStyle->SetPalette(1);

   Double_t x, y, z;

   // Read data from a file and fill the histograms
   std::ifstream inputfile("basic.dat", std::ios::in );
   while ( !inputfile.eof() ) {
      inputfile >> x >> y >> z;
      hx.Fill(x);
      hz->Fill(z);
      hxy.Fill(x,y);
   }
   inputfile.close();

   // Then: 2 ways of referencing the histograms
   hx.SetLineColor(kBlue);
   hx.Draw();
   hz->SetLineColor(kRed);
   hz->Draw("same");

   // Fit of hx
   TF1 *fitx = new TF1("fitx","gaus",-4,4);
   hx.Fit("fitx","R");
   // Get the fit parameters
   Double_t mean = fitx->GetParameter(1);
   Double_t sigma = fitx->GetParameter(2);
   cout<<"mean = "<<mean<<endl;
   cout<<"sigma = "<<sigma<<endl;
   cout<<"FWHM = "<<2.35*sigma<<endl;
   // Get Chi2 and the number of degrees of freedom
   cout<<"Chi2 = "<<fitx->GetChisquare()<<endl;
   cout<<" NDF = "<<fitx->GetNDF()<<endl;

   // Fit of hz
   TF1 *fitz = new TF1("fitz","expo",0,10);
   hz->Fit("fitz","R");
   // Get the fit parameters
   Double_t constant = fitz->GetParameter(0);
   Double_t slope = fitz->GetParameter(1);
   cout<<"constant = "<<constant<<endl;
   cout<<"slope = "<<slope<<endl;
   // Get Chi2/NDF
   cout<<"Chi2/NDF = "<<fitz->GetChisquare()/fitz->GetNDF()<<endl;

   // Open a ROOT file and save the function and histogram
   TFile myfile("fit.root","RECREATE");
   hx.Write();
   hz->Write();
   hxy.Write();
   fitx->Write();
   fitz->Write();

   return;
}
