// PRACTICA ROOT - MASTER TEAFN 2018 - S.E.A. ORRIGO
//
// Fit of graphs: the calibration example
//

/* Ejercicios:

(1) Crear un TGraphErrors con distribución parabolica

(2) Efectuar un ajuste (bestfit) parabolico

*/

void calibration_parabola()
{
 TCanvas *c1 = new TCanvas("c1","calibration_parabola",600,500);
 c1->SetGrid();
 c1->SetFillColor(10);
 c1->cd(1);

 Int_t n = 5; //number of points in the fit
 Double_t Ch[5] = {0,1,10,20,50}; //X-axis: Energy in [channels]
 Double_t En[5] = {0,9,423,1643,10103}; //Y-axis: Energy in [keV]
 Double_t DCh[5] = {0.5,0.5,0.5,0.5,0.5}; //X-errors
 Double_t DEn[5] = {0.5,1,10,100,1000}; //Y-errors

 GraphErrors = new TGraphErrors(n,Ch,En,DCh,DEn);
 GraphErrors->SetMarkerColor(kRed);
 GraphErrors->SetMarkerStyle(20);
 GraphErrors->SetMarkerSize(1.3);
 GraphErrors->SetTitle("Best-fit calibration");
 GraphErrors->GetXaxis()->SetTitle("Energy [channels]");
 GraphErrors->GetYaxis()->SetTitle("Energy [keV]");
 GraphErrors->GetYaxis()->SetTitleOffset(1.3);
 GraphErrors->GetHistogram()->SetMinimum(En[0]-500);  //Y_min
 GraphErrors->GetHistogram()->SetMaximum(En[4]+1200); //Y_max
 GraphErrors->Draw("AP");

 TF1 *bestfit = new TF1("bestfit","pol2",Ch[0]-10,Ch[4]+10);
 bestfit->SetLineWidth(2);
 bestfit->SetLineColor(kRed);
 bestfit->SetLineStyle(2);
 GraphErrors->Fit("bestfit","R");
 gStyle->SetOptFit(1); //TPaveStats: to see the fit statistics, 1 = default

 //Get the fit parameters
 Double_t param[3];
 bestfit->GetParameters(&param[0]);
 cout<<param[0]<<", "<<param[1]<<", "<<param[3]<<endl;

 //Saving the plots
 c1->SaveAs("calibration_parabola.png");
}