// PRACTICA ROOT - MASTER TEAFN 2018 - S.E.A. ORRIGO
//
// Fit of graphs: the calibration example
//

/* Ejercicios:

(1) Crear un TGraphErrors con distribución parabolica

(2) Efectuar un ajuste (bestfit) parabolico

*/

//C,C++ Libraries
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <cmath>
#include <cstdlib>
#include <vector>
#include <iomanip>

// ROOT libraries
#include <TROOT.h>
#include <TF1.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TCanvas.h>
#include <TTree.h>
#include <TChain.h>
#include <TObject.h>
#include <TStyle.h>
#include <TBrowser.h>
#include <TApplication.h>
#include <TFile.h>
#include <TRandom3.h>
#include <TCutG.h>
#include <TString.h>
#include <TObjArray.h>
#include <TPaveLabel.h>
#include <TGraphErrors.h>

void calibration()
{
 TCanvas *c1 = new TCanvas("c1","calibration",600,500);
 c1->SetGrid();
 c1->SetFillColor(10);
 c1->cd(1);

 Int_t n = 5; //number of points in the fit
 Double_t Ch[5] = {10,20,30,40,50}; //X-axis: Energy in [channels]
 Double_t En[5] = {100,200,300,400,500}; //Y-axis: Energy in [keV]
 Double_t DCh[5] = {0.1,0.1,0.1,0.1,0.1}; //X-errors
 Double_t DEn[5] = {1.,1.,1.,1.,1.}; //Y-errors

 TGraphErrors * GraphErrors = new TGraphErrors(n,Ch,En,DCh,DEn);
 GraphErrors->SetMarkerColor(kRed);
 GraphErrors->SetMarkerStyle(20);
 GraphErrors->SetMarkerSize(1.3);
 GraphErrors->SetTitle("Best-fit calibration");
 GraphErrors->GetXaxis()->SetTitle("Energy [channels]");
 GraphErrors->GetYaxis()->SetTitle("Energy [keV]");
 GraphErrors->GetYaxis()->SetTitleOffset(1.3);
 GraphErrors->GetHistogram()->SetMinimum(En[0]-100);  //Y_min
 GraphErrors->GetHistogram()->SetMaximum(En[4]+200); //Y_max
 GraphErrors->Draw("AP");

 TF1 *bestfit = new TF1("bestfit","pol1",Ch[0]-10,Ch[4]+10);
 bestfit->SetLineWidth(2);
 bestfit->SetLineColor(kRed);
 bestfit->SetLineStyle(2);
 GraphErrors->Fit("bestfit","R");
 gStyle->SetOptFit(1); //TPaveStats: to see the fit statistics, 1 = default

 //Get the fit parameters
 Double_t param[2];
 bestfit->GetParameters(&param[0]);
 cout<<param[0]<<", "<<param[1]<<endl;

 //Saving the plots
 c1->SaveAs("calibration.png");
}