//
// Adapted from the ROOT tutorial 
// // $ROOTSYS/tutorials/tree/basic.C
// // $ROOTSYS/tutorials/tree/tree1.C
// 
// Shows how to read & write an ASCII file and fill a TTree & Branch
// 
// Compilación: 
// .L basic_reader.C++

#include <iostream>
#include <fstream>

#include "TFile.h"
#include "TTree.h"

#include "TCanvas.h"
#include "TH1D.h"
#include "TH2D.h"


// el fichero basic.dat tiene tres columnas de números decimales
// definimos una clase para meter cada fila en un objeto
class myEvent_t
{
public:
  myEvent_t():x(0),y(0){}
  ~myEvent_t(){}
   Double_t x;
   Double_t y;
   //Double_t z;
};


// Función para leer el tree creado con basicWriter()
int basic_reader()
{
  // abrimos el fichero
  TFile * ifile = TFile::Open("basic.root","read");
  // si el fichero no existe, TFile::Open devolerá un puntero nulo, cero
  if( ifile == NULL ) return -1;
  TTree * itree = 0;
  // buscamos dónde está el tree que nos interesa, llamado "aTree"
  ifile->GetObject("aTree", itree);
  // si no lo ha encontrado, itree será nulo, cero
  if( itree == NULL) return -2;
  
  myEvent_t anEvent;
  
  itree->SetBranchAddress("myBranch.", &(anEvent.x));
  
  Long64_t nEntries = itree->GetEntries();
  
  for( Long64_t i = 0; i<nEntries; ++i)
  {
    itree->GetEntry(i);
    // sacamos por pantalla los valores
    std::cout << anEvent.x << "\t" <<
	         anEvent.y << std::endl;
    
  }
  return 0;
}

