
////////////////////////////////////////////////////////////////////////
//    Program to visualize PalmTop MCA data (master 2013)             //
//    Jan-2013 E. Nacher                                              //
////////////////////////////////////////////////////////////////////////


{
	//Variables to read (and others...)
	
	char InputFileName[60], field[60];
	int NumberOfChannels = 8192, i = 0;
	int Histo[NumberOfChannels];
	float dummy;
	
	system("clear");
	cout << endl << endl << endl << endl << endl;
	cout << "********** Data files in current folder **********" << endl << endl;
	system("ls -tal *.mca");
 	cout << endl << endl << endl;
	cout << "Enter input file name: ";
	cin >> InputFileName;
	ifstream InputFile(InputFileName);
	
	if(InputFile.good() == 0){
		cout << "No such file!!" << endl;
		return 0;
		}
		
		//Initialize arrays to zero
		
		for(i=0; i < NumberOfChannels ; i++){
			Histo[i]=0;
		}
		
		//Reading and processing data 
		
		cout << endl << endl;
		
		cout << "Processing data..." << endl;
		
		TH1F* RootHist = new TH1F("MCA Spectrum","",NumberOfChannels,0,NumberOfChannels);
		
		while(InputFile >> field) {
			
			if(field[2]=='D' & field[3]=='A') break;
		}	
		
		i=0;
		
		while(i < NumberOfChannels && InputFile.good()){
			InputFile >> Histo[i];
			RootHist->Fill(i,Histo[i]);
			i++;
		}		
		
		
		// set default graphics options
		
		gROOT->SetStyle("Plain");
		gStyle->SetOptStat(1000011);
		gStyle->SetPalette(1);
		
		RootHist->GetXaxis()->SetTitleSize(0.035);
		RootHist->GetXaxis()->SetLabelSize(0.035);
		RootHist->GetXaxis()->SetTitle("Channel");
		
		RootHist->GetYaxis()->SetTitleSize(0.035);
		RootHist->GetYaxis()->SetLabelSize(0.035);
		RootHist->GetYaxis()->SetTitleOffset(1.4);
		RootHist->GetYaxis()->SetTitle("Counts");
		
		RootHist->SetLineWidth(2);
		RootHist->SetLineColor(2);
		RootHist->Draw();
		
	}